---
generated_at: 2026-01-21 19:20:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-Windows Terminal未検出警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalClass.vb` 行1386-1401（ShowCommandLinePreview関数）
- E-02: `Source/General/GlobalClass.vb` 行1395-1399（Windows Terminal処理）
- E-03: `Source/General/GlobalClass.vb` 行1398（MsgWarn呼び出し）
- E-04: `Source/General/General.vb` 行1245-1255（MsgWarn関数定義）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行26（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルは「Windows Terminal not found!」である | E-03 (行1398) | ○ |
| C-02 | 本文は「Windows Terminal could not be found and thus Powershell will be used to show the command line preview!」である | E-03 (行1398) | ○ |
| C-03 | MsgWarn関数で警告ダイアログを表示する | E-03, E-04 | ○ |
| C-04 | g.IsWindowsTerminalAvailableで判定する | E-02 (行1395) | ○ |
| C-05 | Select Case s.CommandLinePreviewで分岐する | E-01 (行1386) | ○ |
| C-06 | 警告後にPowershellへフォールバックする | E-02 (行1399) | ○ |
| C-07 | wt.exeでWindows Terminalを起動する | E-02 (行1396) | ○ |
| C-08 | powershell.exeでPowershellを起動する | E-02 (行1399) | ○ |
| C-09 | Powershellへフォールバックすることを備考に記載 | E-05 (行26備考) | ○ |
| C-10 | 通知カテゴリは「Windows Terminal未検出警告」である | E-05 (行26) | ○ |
| C-11 | 環境変数CommandLineToShowを設定する | E-01 (行1393) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vb 行1386-1401の実装が設計書の記述と一致しているか確認
- [ ] IsWindowsTerminalAvailableプロパティの実装を確認
- [ ] CommandLinePreview列挙型の定義を確認
